db 60                 ; 1st run piano, then french horn
db 0x9b,25,114        ; play note 25 with volume 114
nop                   ; align executable music data
mov al,13h            ; set graphic mode
int 10h               ; 320x200 pixels, 256 colors
Y: mov cl,62          ; 62 = length of this code
push si               ; save pointer to music data
mov dx,0x330          ; MIDI port (requires UART)
rep outsb             ; send code as data to MIDI port
pop si                ; restore pointer to music data
push 0xa000           ; set ES to start of visible screen
pop es                ; 2 extra bytes to work everywhere
X: mov bl,126         ; Depth D, start at ~0 (signed)
L: inc bx             ; D++, advance ray
mov ax,0xcccd         ; Rrrola trick, convert screen
mul di                ; ... pointer DI to Y,X in DH, DL
mov al,dh             ; get Y in AL
add al,92             ; center forest in the middle
imul bl               ; Y' projection, result in AH
xchg ax,dx            ; save Y' in DH, get X in AL
mul bl                ; X' projection, result in AH
add ax,bp             ; X'' = X' + T (high byte of BP)
or ah,bl              ; sierpinski pyramid formula
and ah,dh             ; H = ( X'' | D ) & Y'
jnz L                 ; if not hit, continue ray
xchg bx,ax            ; get number of steps in AL
inc ax                ; map number of steps ...
shr al,3              ; .. to black white scale
stosb                 ; write pixel value and advance
imul di,byte 85       ; antiflicker, rough look
loop X                ; frame loop (65536 pixels)
add bp,si             ; T++, high byte of BP (SI=100h)
jmp short Y           ; repeat, also change instrument...